/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.worldgen.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import me.ultrusmods.missingwilds.register.MissingWildsFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class BranchTreeDecorator
extends TreeDecorator {
    public static final Codec<BranchTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(branchTreeDecorator -> branchTreeDecorator.branchProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("bee_probability").forGetter(branchTreeDecorator -> Float.valueOf(branchTreeDecorator.beeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_probability").forGetter(branchTreeDecorator -> Float.valueOf(branchTreeDecorator.branchProbability))).apply((Applicative)instance, BranchTreeDecorator::new));
    public final BlockStateProvider branchProvider;
    public final float beeProbability;
    public final float branchProbability;

    public BranchTreeDecorator(BlockStateProvider branchProvider, float beeProbability, float branchProbability) {
        this.branchProvider = branchProvider;
        this.beeProbability = beeProbability;
        this.branchProbability = branchProbability;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return MissingWildsFeatures.BRANCH_TREE.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        LevelSimulatedReader world = context.m_226058_();
        ObjectArrayList logPositions = context.m_226068_();
        if (random.m_188501_() >= this.branchProbability) {
            return;
        }
        int maxY = ((BlockPos)logPositions.get(logPositions.size() - 1)).m_123342_();
        int minY = ((BlockPos)logPositions.get(0)).m_123342_();
        boolean generatedBranch = false;
        for (BlockPos blockPos : logPositions) {
            BlockPos downPos;
            if (generatedBranch) break;
            if (blockPos.m_123342_() < (maxY + minY) / 2) continue;
            Direction direction = Direction.m_122407_((int)random.m_188502_());
            BlockPos checkPos = blockPos.m_121945_(direction);
            if (context.m_226059_(checkPos)) {
                BlockState state = this.branchProvider.m_213972_(random, checkPos);
                if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)direction.m_122434_());
                }
                generatedBranch = true;
                context.m_226061_(checkPos, state);
            }
            if (!context.m_226059_(downPos = checkPos.m_7495_()) || !(random.m_188501_() < this.beeProbability)) continue;
            context.m_226061_(downPos, (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)direction));
            world.m_141902_(downPos, BlockEntityType.f_58912_).ifPresent(blockEntity -> {
                int i = 2 + random.m_188503_(2);
                for (int j = 0; j < i; ++j) {
                    CompoundTag nbtCompound = new CompoundTag();
                    nbtCompound.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                    blockEntity.m_155157_(nbtCompound, random.m_188503_(599), false);
                }
            });
        }
    }
}

